/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.selectwf;

import filenet.vw.api.VWException;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWTransferResult;
import filenet.vw.api.VWValidationError;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.apps.selectwf.GetDoc;
import filenet.vw.apps.selectwf.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.IVWIDMDocument;
import filenet.vw.idm.toolkit.IVWIDMLink;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.utils.VWBaseAppLauncherApplet;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWOpenItem;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class VWSelectWFPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 464L;
    private Container m_mainContainer = null;
    private JApplet m_parentApplet = null;
    private Frame m_parentFrame = null;
    private VWSession m_vwSession = null;
    private IVWIDMDocument m_IDMDocument = null;
    private IVWIDMLink[] m_workflowLinks = null;
    private VWOpenItem m_vwOpenItem = null;
    private String m_vwVersionFromTransfer = null;
    private JRadioButton m_useMainAttachmentButton = null;
    private JRadioButton m_selectAWorkflowButton = null;
    private ButtonGroup m_buttonGroup = null;
    private JComboBox m_workflowSelectionComboBox = null;
    private JButton m_okButton = null;
    private JButton m_cancelButton = null;
    private JButton m_helpButton = null;

    public void init(VWSessionInfo sessionInfo) {
        try {
            this.m_mainContainer = sessionInfo.getParentContainer();
            this.m_parentApplet = sessionInfo.getParentApplet();
            this.m_vwSession = sessionInfo.getSession();
            String libraryName = sessionInfo.getProperty("library");
            String documentId = sessionInfo.getProperty("docId");
            this.m_parentFrame = VWModalDialog.getParentFrameUsingContainer(this.m_mainContainer);
            this.m_vwOpenItem = new VWOpenItem(this.m_vwSession, this.m_mainContainer, this.m_parentApplet);
            this.setupIDMEnvironmentEx(this.m_vwSession.getToken(), libraryName, documentId);
            if (this.m_IDMDocument == null) {
                this.doClose();
                return;
            }
            this.createControls();
            if (this.m_IDMDocument.isWorkflowDefinition() && this.m_workflowLinks == null) {
                this.m_useMainAttachmentButton.setSelected(true);
                this.doLaunch();
                return;
            }
            if (!this.m_IDMDocument.isWorkflowDefinition() && this.m_workflowLinks != null && this.m_workflowLinks.length == 1) {
                this.m_workflowSelectionComboBox.setSelectedIndex(0);
                this.doLaunch();
                return;
            }
            if (!this.m_IDMDocument.isWorkflowDefinition() && this.m_workflowLinks == null) {
                JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_noWorkflowLinked, VWResource.s_failedLaunchingWorkflow, 1);
                this.doClose();
                return;
            }
            if (this.m_useMainAttachmentButton == null) {
                Dimension dim = VWStringUtils.stringToDimension(VWResource.s_smallApplicationDimensions);
                if (dim == null) {
                    this.m_mainContainer.setSize(450, 250);
                } else {
                    this.m_mainContainer.setSize(dim);
                }
            } else {
                Dimension dim = VWStringUtils.stringToDimension(VWResource.s_largeApplicationDimensions);
                if (dim == null) {
                    this.m_mainContainer.setSize(450, 315);
                } else {
                    this.m_mainContainer.setSize(dim);
                }
            }
            this.m_mainContainer.setVisible(true);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        if (this.m_mainContainer != null) {
            this.m_mainContainer.invalidate();
            this.m_mainContainer.validate();
            this.m_mainContainer.repaint();
        }
    }

    public void destroy() {
    }

    public void actionPerformed(ActionEvent event) {
        try {
            Object source = event.getSource();
            if (source.equals(this.m_useMainAttachmentButton)) {
                this.m_workflowSelectionComboBox.setEnabled(false);
            } else if (source.equals(this.m_selectAWorkflowButton)) {
                this.m_workflowSelectionComboBox.setEnabled(true);
            } else if (source.equals(this.m_okButton)) {
                if (this.doLaunch()) {
                    this.doClose();
                }
            } else if (source.equals(this.m_cancelButton)) {
                if (this.doCancel()) {
                    this.doClose();
                }
            } else if (source.equals(this.m_helpButton)) {
                VWHelp.displayPage(VWHelp.Help_eProcess_Doc + "launch/vwselectwf.htm");
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected boolean doCancel() {
        try {
            int selection = JOptionPane.showConfirmDialog(this.m_parentFrame, VWResource.s_cancelWarning, VWResource.s_confirmCancel, 0, 2);
            return selection != 1;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return false;
        }
    }

    public void setupIDMEnvironmentEx(String tok, String libraryName, String documentId) throws VWException {
        if (GetDoc.is142) {
            try {
                GetDoc c = new GetDoc(libraryName, documentId, tok);
                EventQueue.invokeAndWait(c);
                this.m_IDMDocument = c.getDocument();
            }
            catch (Throwable t) {
                VWDebug.logException(new Exception("Error retrieving document in setupIDMEnvironmentEx().", t));
            }
        } else {
            this.m_IDMDocument = VWIDMBaseFactory.instance().getIDMDocument(libraryName, documentId, null);
        }
    }

    private void createControls() {
        JLabel label = null;
        GridBagConstraints gbCons = null;
        int row = 0;
        VWToolbarBorder toolbarBorder = null;
        try {
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            gbCons.anchor = 21;
            gbCons.fill = 2;
            gbCons.insets = new Insets(4, 4, 4, 4);
            gbCons.ipadx = 0;
            gbCons.ipady = 0;
            toolbarBorder = new VWToolbarBorder(VWResource.s_selectedDocument, 0);
            gbCons.gridy = row++;
            this.add((Component)toolbarBorder, gbCons);
            if (this.m_IDMDocument != null) {
                label = new JLabel(this.m_IDMDocument.getLabel());
                toolbarBorder.getClientPanel().setLayout(new BorderLayout(4, 4));
                toolbarBorder.getClientPanel().add((Component)label, "First");
            }
            toolbarBorder = new VWToolbarBorder(VWResource.s_launch, 0);
            toolbarBorder.getClientPanel().setLayout(new GridBagLayout());
            toolbarBorder.getClientPanel().setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 0));
            gbCons.gridy = row++;
            this.add((Component)toolbarBorder, gbCons);
            if (this.m_IDMDocument.isWorkflowDefinition()) {
                gbCons.gridy = row++;
                toolbarBorder.getClientPanel().add((Component)this.getChoicePanel(), gbCons);
                gbCons.gridy = row++;
                gbCons.insets = new Insets(0, 25, 4, 4);
                toolbarBorder.getClientPanel().add((Component)this.getWorkflowSelectPanel(), gbCons);
            } else {
                label = new JLabel(VWResource.s_selectWorkflowLink);
                gbCons.gridy = row++;
                toolbarBorder.getClientPanel().add((Component)label, gbCons);
                gbCons.gridy = row++;
                toolbarBorder.getClientPanel().add((Component)this.getWorkflowSelectPanel(), gbCons);
            }
            gbCons.gridy = row++;
            gbCons.insets = new Insets(4, 4, 4, 4);
            this.add((Component)this.getButtonPanel(), gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel getChoicePanel() {
        JPanel panel = null;
        JLabel label = null;
        try {
            panel = new JPanel();
            panel.setLayout(new BorderLayout(4, 4));
            panel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            this.m_buttonGroup = new ButtonGroup();
            label = new JLabel(VWResource.s_thisDocumentIsAWorkflow);
            panel.add((Component)label, "First");
            this.m_useMainAttachmentButton = new JRadioButton(VWResource.s_launchIt, false);
            this.m_useMainAttachmentButton.addActionListener(this);
            this.m_buttonGroup.add(this.m_useMainAttachmentButton);
            this.m_useMainAttachmentButton.setSelected(true);
            panel.add((Component)this.m_useMainAttachmentButton, "Center");
            this.m_selectAWorkflowButton = new JRadioButton(VWResource.s_selectWorkflowLinkBelowAndAttachIt, false);
            this.m_selectAWorkflowButton.addActionListener(this);
            this.m_buttonGroup.add(this.m_selectAWorkflowButton);
            panel.add((Component)this.m_selectAWorkflowButton, "Last");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return panel;
    }

    private JPanel getWorkflowSelectPanel() {
        JPanel panel = null;
        String linkInfo = null;
        try {
            panel = new JPanel();
            panel.setLayout(new BorderLayout(4, 4));
            this.m_workflowSelectionComboBox = new JComboBox();
            this.m_workflowSelectionComboBox.setEditable(false);
            if (this.m_selectAWorkflowButton != null && !this.m_selectAWorkflowButton.isSelected()) {
                this.m_workflowSelectionComboBox.setEnabled(false);
            }
            int isolatedRegion = this.m_vwSession.getIsolatedRegion();
            this.m_workflowLinks = this.m_IDMDocument.getWorkflowLinksForLaunch(0, isolatedRegion);
            if (this.m_workflowLinks != null && this.m_workflowLinks.length > 0) {
                for (int k = 0; k < this.m_workflowLinks.length; ++k) {
                    linkInfo = this.m_workflowLinks[k].getName() + " ( " + this.m_workflowLinks[k].getSubject() + " )";
                    this.m_workflowSelectionComboBox.addItem(linkInfo);
                }
            }
            panel.add((Component)this.m_workflowSelectionComboBox, "First");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return panel;
    }

    private JPanel getButtonPanel() {
        JPanel panel = null;
        try {
            panel = new JPanel();
            panel.setLayout(new FlowLayout(1, 4, 4));
            panel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
            this.m_okButton = new JButton(VWResource.s_ok);
            this.m_okButton.addActionListener(this);
            panel.add(this.m_okButton);
            this.m_cancelButton = new JButton(VWResource.s_cancel);
            this.m_cancelButton.addActionListener(this);
            panel.add(this.m_cancelButton);
            this.m_helpButton = new JButton(VWResource.s_helpDots);
            this.m_helpButton.addActionListener(this);
            panel.add(this.m_helpButton);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return panel;
    }

    private void doClose() {
        try {
            if (this.m_mainContainer != null && this.m_mainContainer instanceof JFrame) {
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent((JFrame)this.m_mainContainer, 201));
            } else if (this.m_mainContainer != null && this.m_mainContainer instanceof VWBaseAppLauncherApplet) {
                ((VWBaseAppLauncherApplet)this.m_mainContainer).closeWindow();
            }
        }
        catch (Exception ex) {
            this.m_mainContainer.setEnabled(true);
            VWDebug.logException(ex);
        }
    }

    private boolean doLaunch() {
        VWWorkflowDefinition workflowDef = null;
        String vwVersion = null;
        IVWIDMLink workflowLink = null;
        String subject = "";
        String attachmentId = "";
        try {
            if (this.m_useMainAttachmentButton != null && this.m_useMainAttachmentButton.isSelected()) {
                try {
                    vwVersion = this.m_IDMDocument.getVWVersion();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (vwVersion == null || vwVersion != null && !this.m_vwSession.checkWorkflowIdentifier(vwVersion)) {
                    workflowDef = this.readWorkflowDefinition(this.m_IDMDocument);
                    if (workflowDef == null) {
                        return false;
                    }
                    if (!this.validateWorkflow(workflowDef)) {
                        return false;
                    }
                    if (!this.transferWorkflow(workflowDef, this.m_IDMDocument)) {
                        return false;
                    }
                    vwVersion = this.m_vwVersionFromTransfer;
                    if (vwVersion == null) {
                        return false;
                    }
                }
            } else if (this.m_useMainAttachmentButton == null || this.m_selectAWorkflowButton.isSelected()) {
                if (this.m_workflowSelectionComboBox.getSelectedIndex() >= 0) {
                    workflowLink = this.m_workflowLinks[this.m_workflowSelectionComboBox.getSelectedIndex()];
                }
                if (workflowLink == null) {
                    return false;
                }
                vwVersion = workflowLink.getVWVersion();
                subject = workflowLink.getSubject();
                attachmentId = this.m_IDMDocument.getCanonicalName();
                if (vwVersion == null || vwVersion != null && !this.m_vwSession.checkWorkflowIdentifier(vwVersion)) {
                    JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_invalidLink, VWResource.s_failedLaunchingWorkflow, 0);
                    return false;
                }
            } else {
                JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_noWorkflowSelected, VWResource.s_failedLaunchingWorkflow, 0);
                return false;
            }
            this.m_vwOpenItem.openLaunchStepProcessor(this.m_vwSession.fetchLaunchStepProcessor(vwVersion), vwVersion, subject, attachmentId);
            return true;
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.m_parentFrame, ex, VWResource.s_failedLaunchingWorkflow, 0);
            VWDebug.logException(ex);
            return false;
        }
    }

    private boolean validateWorkflow(VWWorkflowDefinition workflowDef) {
        VWValidationError[] errors = null;
        try {
            if (workflowDef == null) {
                return false;
            }
            this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(3));
            errors = workflowDef.validate(this.m_vwSession, false);
            this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
            if (errors != null) {
                JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_workflowFailedValidation, VWResource.s_failedLaunchingWorkflow, 0);
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.m_parentFrame, ex, VWResource.s_failedLaunchingWorkflow, 0);
            VWDebug.logException(ex);
            return false;
        }
    }

    private boolean transferWorkflow(VWWorkflowDefinition workflowDef, IVWIDMDocument workflowDoc) {
        VWTransferResult tferErrors = null;
        boolean bSuccess = true;
        try {
            if (workflowDef == null) {
                return false;
            }
            this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(3));
            tferErrors = this.m_vwSession.transfer(workflowDef, workflowDoc.getCanonicalNameWithVer(), false, false);
            if (!tferErrors.success()) {
                VWMessageDialog.showOptionDialog(this.m_parentFrame, tferErrors.getErrors(), null, 1, 16, null, 350, 250);
                bSuccess = false;
            } else {
                this.m_vwVersionFromTransfer = tferErrors.getVersion();
                workflowDoc.setVWVersion(this.m_vwVersionFromTransfer);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            bSuccess = false;
        }
        this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
        return bSuccess;
    }

    private VWWorkflowDefinition readWorkflowDefinition(IVWIDMDocument workflowDoc) {
        VWWorkflowDefinition newWorkflowDefinition = null;
        try {
            if (workflowDoc == null) {
                return null;
            }
            this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(3));
            byte[] fileContents = workflowDoc.getContents();
            ByteArrayInputStream inStream = new ByteArrayInputStream(fileContents);
            newWorkflowDefinition = VWWorkflowDefinition.read(inStream);
            fileContents = null;
            inStream.close();
            this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
            return newWorkflowDefinition;
        }
        catch (Exception e) {
            VWDebug.logException(e);
            JOptionPane.showMessageDialog(this.m_parentFrame, e.getMessage(), VWResource.s_FNOpenErrTitle, 0);
            return null;
        }
    }
}

